function [stats, vnames, colnames]=StructStats(s, PrintFile)
%	STRUCTSTATS - [stats, vnames, colnames]=StructStats(s, PrintFile)

if nargin==1
   PrintFile=0;
end

vnames = fieldnames(s);
nvar = length(vnames);
dn = zeros(nvar,1);
dmax = dn;
dmin = dn;
dstd = dn;
dmean = dn;
for i=1:nvar
   x = eval(['[s.' vnames{i} ']']);
   dn(i) = length(x);
   dmin(i) = min(x);
   dmax(i) = max(x);
   dmean(i) = mean(x);
   dstd(i) = std(x);
end;
stats = [dn dmean dstd dmin dmax];
colnames={'n','mean','std','min','max'};

if PrintFile~=0
   PrintMatrix(stats,vnames,colnames,{'%6.0f','%11g'});
end




   
      
